const { Schema } = require('mongoose')

const schema = new Schema({
  content: { type: String, required: true },
  updateUser: { type: String },
}, {
  versionKey: false,
  collection: 'notify', // 表名
  timestamps: true,
})

schema.statics.getNotify = function (query) {
  if (query.content) {
    query.content = new RegExp(query.content)
  }
  return this.find(query).sort({ updatedAt: -1 }).lean()
}

schema.statics.save = async function (doc) {
  if (doc._id) {
    delete doc.updatedAt
    return this.update({
      _id: doc._id,
    }, doc)
  }
  return this.create(doc)
}

schema.statics.delete = function (id) {
  return this.findByIdAndRemove(id)
}

module.exports = schema
