const Router = require('koa-router')
const bodyParser = require('koa-bodyparser')
const _ = require('lodash')
const qs = require('querystring')

const config = require(global.configPath)

const router = new Router()
module.exports = router

const create = async (ctx) => {
  const body = ctx.request.body
  const dependant = body.dependant

  const rule = {
    description: 'required',
    namespace: 'required',
  }

  if (!ctx.validate(body, rule)) {
    ctx.body = ctx.fail(ctx.Code.ERROR_INPUT)
    return
  }

  const res = await ctx.curl({
    uri: `${config.api.tke_api}/namespace/info?namespace=${qs.escape(body.namespace)}`,
    method: 'get',
    headers: {
      cluster: ctx.request.headers.cluster,
    },
  })
  const ns = _.get(res, 'body.data.name', '')
  if (!ns) {
    await ctx.curl({
      uri: `${config.api.tke_api}/namespace/create`,
      body: {
        name: body.namespace,
        description: body.description,
      },
      headers: {
        cluster: ctx.request.headers.cluster,
      },
    })
  }

  if (dependant.base) {
    for (let i = dependant.base.length - 1; i >= 0; i -= 1) {
      const app = dependant.base[i]
      await ctx.curl({
        uri: `${config.api.tke_api}/service/create`,
        body: {
          type: app.type,
          serviceName: app.type,
          namespace: body.namespace,
          image: app.tag,
          label: 'base',
        },
        headers: {
          cluster: ctx.request.headers.cluster,
        },
      })
    }
  }

  const key = Object.keys(dependant).filter(prop => prop !== 'base')
  for (let i = key.length - 1; i >= 0; i -= 1) {
    const type = key[i]
    for (let j = dependant[type].length - 1; j >= 0; j -= 1) {
      const app = dependant[type][j]
      const res = await ctx.curl({
        uri: `${config.api.tke_api}/service/create`,
        body: {
          type: app.type,
          serviceName: app.appname,
          namespace: body.namespace,
          image: app.tag.replace(`qa-${app.type}`, 'qa-test'),
          label: app.label,
          domain: app.domain,
          debug: '"0"',
        },
        headers: {
          cluster: ctx.request.headers.cluster,
        },
      })
      if (res.body.code !== '0000') {
        throw new Error(res.body.msg)
      }
    }
  }

  ctx.body = ctx.ok()
}

const getGroup = async (ctx) => {
  const group = ['test', 'dev']
  ctx.body = ctx.ok(group)
}


router
  .use(bodyParser())
  .post('/create', create)
  .get('/get_group', getGroup)
