

const path = require('path')

const logDir = path.resolve(process.cwd(), './logs')

module.exports = {
  api: {
    sc_api: 'http://192.168.4.24:7021',
    eos_api: 'http://192.168.6.13',
    tke_api: 'http://127.0.0.1:4000',
    mq_api: 'http://172.30.3.140:15672',
    harbor_api: '192.168.4.4/library/',

  },

  redis: {
    sentinels: [{
      host: 'opapi-redis1.quantgroups.com', port: 26379,
    },
    {
      host: 'opapi-redis2.quantgroups.com', port: 26379,
    },
    {
      host: 'opapi-redis3.quantgroups.com', port: 26379,
    }],
  },

  syncDB: {
    defaultUsername: 'xyqb_query',
    defaultPasswd: 'Uiwb@o^fR&nHOa5t',
  },

  syncMq: {
    auth: 'Basic cWE6cWF0ZXN0',
  },

  jenkins: {
    api: 'http://qahome:Quantgroup123@172.29.1.15:8080',
  },
  gitlab: {
    token: 'owKJZwenxNaypTAz4Zcd',
  },
  log4js: {
    appenders: {
      out: { type: 'stdout' },
      app: {
        type: 'dateFile', filename: `${logDir}/qa-api.log`, daysToKeep: 3, compress: true,
      },
      error: {
        type: 'dateFile', filename: `${logDir}/qa-api.error.log`, daysToKeep: 3, compress: true,
      },
      timing: {
        type: 'dateFile', filename: `${logDir}/qa-api.timing.log`, daysToKeep: 3, compress: true,
      },
      just_errors: { type: 'logLevelFilter', appender: 'error', level: 'error' },
    },
    categories: {
      default: { appenders: ['out', 'app', 'just_errors'], level: 'info' },
      timing: { appenders: ['out', 'timing'], level: 'info' },
    },
  },

  mongo: {
    api: 'mongodb://172.30.220.22:27017/qaHome',
    // api: 'mongodb://127.0.0.1:27017/qaHome'
  },

  ldap: {
    url: 'ldap://ldap.quantgroups.com:389',
    bindDN: 'cn=common_auth_query,cn=users,DC=quantgroup,DC=cn',
    bindCredentials: 'Quantgroup.com@2o17',
    searchBase: 'ou=北京量科邦信息技术有限公司,dc=quantgroup,dc=cn',
    searchAttributes: ['cn', 'SAMACCOUNTNAME', 'title', 'mail'],
    searchFilter: '(SAMACCOUNTNAME={{username}})',
    reconnect: true,
  },

  QaHome: 'http://192.168.28.179:4200',
  BlackPreal: 'http://192.168.28.179:10085/home/index/',
  CiCD: '',

  binlogDir: '/Users/zhiyong/IdeaProjects/github/binlog2sql/binlog2sql',
  dingTalk: 'http://localhost:9000',
}
