const Router = require('koa-router')
const _ = require('lodash')
const logger = require('koa-log4').getLogger()

const config = require(global.configPath)

const ProConfig = require('../service/mongoService').ProConfig
const repoService = require('../service/repoService')

const router = new Router()
module.exports = router

const QA = 'qa-'

const getAllRepos = async (ctx) => {
  // 获取qa-开头的所有namespace
  const res = await Promise.all([
    ctx.curl({
      uri: `${config.api.tke_api}/repository/getNamespaceInfo?namespace=${QA}`,
    }),
    ProConfig.getActiveProjectsHostName(),
  ])
  const ns = _.get(res[0], 'body.data.namespaceInfo', [])
  ctx._domains = res[1]

  const task = []
  for (let i = 0; i < ns.length; i += 1) {
    logger.info('要查询的namespace:', ns[i])
    ns[i].type = ns[i].namespace.replace(QA, '')
    task.push(repoService.getRepoOfNs(ctx, ns[i]))
  }
  await Promise.all(task)
  ns.sort((a, b) => (a.type > b.type ? 1 : -1))
  ctx.body = ctx.ok(ns)
}

const getBaseRepos = async (ctx) => {
  const ns = [{
    type: 'base',
    namespace: `${QA}base`,
  }]
  await repoService.getRepoOfNs(ctx, ns[0])
  ctx.body = ctx.ok(ns)
}

const getAppRepos = async (ctx) => {
  const res = await Promise.all([
    ctx.curl({
      uri: `${config.api.tke_api}/repository/getNamespaceInfo?namespace=${QA}`,
    }),
    ProConfig.getActiveProjectsHostName(),
  ])
  const ns = _.get(res[0], 'body.data.namespaceInfo', []).filter(item => item.namespace !== `${QA}base`)
  ctx._domains = res[1]

  const task = []
  for (let i = 0; i < ns.length; i += 1) {
    logger.info('要查询的namespace:', ns[i])
    ns[i].type = ns[i].namespace.replace(QA, '')
    task.push(repoService.getRepoOfNs(ctx, ns[i]))
  }
  await Promise.all(task)
  ns.sort((a, b) => (a.type > b.type ? 1 : -1))
  ctx.body = ctx.ok(ns)
}

router
  .get('/getAll', getAllRepos)
  .get('/getBase', getBaseRepos)
  .get('/getApp', getAppRepos)
