
const { Schema } = require('mongoose')

const initPort = 7000

// 表结构
const schema = new Schema({
  git_lab: { type: String, required: true },
  port: { type: Number },
  is_active: { type: Boolean },
  deploy_to_testenv: { type: Boolean },
  sonar: { type: Boolean },
  type: { type: String, required: true },
  git_path: {
    type: String, unique: true, required: true, index: true,
  },
  git_path_group: { type: String, required: true },
  project_name: { type: String, required: true },

  host_name: { type: String },
  log_path: { type: String },
  config_path: { type: String },
  des: { type: String },
  auth: { type: String },
  jar_path: { type: String },
  command1: { type: String },
  build_command: { type: String },
  start_command: { type: String },
  stop_command: { type: String },
  api: { type: String },
  ddl: { type: String },
  wiki: { type: String },
  database: { type: String },
  cpuRequest: { type: Number },
  cpuLimit: { type: Number },
  memRequest: { type: Number },
  memLimit: { type: Number },
}, {
  versionKey: false,
  collection: 'proconfigs', // 表名
  timestamps: true,
})

schema.statics.getActiveProjectsHostName = function () {
  return this.find({ des: { $ne: '海外' }, is_active: 1 }).select(['host_name', 'project_name', 'type']).lean().then((res) => {
    const reg = /^([\w-\.]+)\.[\w-]+\.[a-z]+$/
    // 转为对象形式
    const o = res.reduce((prev, next) => {
      const regRes = reg.exec(next.host_name)
      prev[next.project_name] = {
        hostname: next.host_name,
        domain: regRes ? regRes[1] : '',
        type: next.type,
      }
      return prev
    }, {})
    return o
  })
}

schema.statics.findByQuery = function (query, column, sort) {
  if (query.project_name) {
    query.project_name = new RegExp(query.project_name)
  }
  return this.find(query, column).sort(sort).lean()
}

schema.statics.getOneProject = function (query, column) {
  return this.findOne(query, column)
}

schema.statics.saveProject = function (doc) {
  if (doc._id) {
    return this.update({
      _id: doc._id,
    }, doc)
  }
  return this.create(doc)
}

schema.statics.getNewPort = async function () {
  const item = await this.findOne().select('port').sort({ port: -1 })
  if (!item || (item.port < initPort)) {
    return initPort
  }
  return item.port
}

schema.statics.delete = function (id) {
  return this.findByIdAndRemove(id)
}
schema.statics.getType = function () {
  return this.aggregate([
    { $match: {} },
    { $group: { _id: '$type', total: { $sum: 1 } } },
  ]).sort({ total: -1 })
}
module.exports = schema
