const _ = require('lodash')

const config = require(global.configPath)

const QA = 'qa-'
const BASEREPO = 'qa-base'
const LASTEST = 'latest'

async function getTagOfRepo(ctx, repo) {
  const res = await ctx.curl({
    uri: `${config.api.tke_api}/repository/getTags`,
    method: 'POST',
    body: {
      reponame: repo.reponame,
    },
  })
  repo.tags = _.get(res, 'body.data.tagInfo', []).map(item => item.tagName)
}

async function getRepoOfNs(ctx, ns) {
  const isBaseRepo = BASEREPO === ns.namespace
  // 服务部署后，在运行中环境，通过label信息来展示列表
  const label = ns.namespace.replace(QA, '')

  const res = await ctx.curl({
    uri: `${config.api.tke_api}/repository`,
    method: 'POST',
    body: {
      namespace: ns.namespace,
    },
  })

  let repos = _.get(res, 'body.data.repoInfo', []).map((item) => {
    const appname = item.reponame.split('/')[1]
    const o = {
      reponame: item.reponame,
      appname,
    }
    if (item.reponame.indexOf(BASEREPO) === -1) {
      o.hostname = (ctx._domains[appname] && ctx._domains[appname].hostname) || ''
      o.domain = (ctx._domains[appname] && ctx._domains[appname].domain) || ''
    }
    return o
  })

  const task = []
  for (let i = 0, len = repos.length; i < len; i += 1) {
    if (isBaseRepo) {
      task.push(getTagOfRepo(ctx, repos[i]))
    }
  }
  await Promise.all(task)

  // 把tag信息拉平到appname上
  const m = []
  console.log(1, repos)
  repos.forEach((item) => {
    const tags = item.tags || [LASTEST]
    tags.forEach((tag) => {
      // console.log(1, item, ctx._domains[item.appname])
      m.push({
        // 部署时用于选择服务模板
        type: isBaseRepo ? item.appname : ctx._domains[item.appname].type,
        label: isBaseRepo ? label : ctx._domains[item.appname].type,
        appname: isBaseRepo ? `${item.appname}:${tag}` : item.appname,
        tag: `${item.reponame}:${tag}`,
        // domain用于部署服务时的域名映射
        domain: isBaseRepo ? `${item.appname}${tag}` : item.domain,
      })
    })
  })
  repos = m

  repos.sort((a, b) => (a.appname > b.appname ? 1 : -1))

  ns.repos = repos
  delete ns.repoCount
  delete ns.creationTime
  delete ns.namespace
}

exports.getRepoOfNs = getRepoOfNs
