

const Router = require('koa-router')

const router = new Router()
const proxy = require('request-proxy')

const config = require(global.configPath)

const error = require('./middleware/error')
const result = require('./middleware/result')
const qalog = require('../app/middleware/qalog')
const validate = require('./middleware/validate')

const proconfig = require('./controller/proconfig')
const k8s = require('./controller/k8s')
const docker = require('./controller/docker')
const user = require('./controller/user')
const index = require('./controller/indexurl')
const dbconfig = require('./controller/dbconfig')
const dbsync = require('./controller/dbsync')
const binlog2sql = require('./controller/binlog2sql')
const harborHook = require('./controller/harborHook')
const log = require('./controller/log')
const repo = require('./controller/repo')
const repoNew = require('./controller/repoNew')
const envTemplate = require('./controller/envTemplate')
const env = require('./controller/env')
const pipeline = require('./controller/pipeline')
const resource = require('./controller/resource')
const cluster = require('./controller/cluster')
const notify = require('./controller/notify')
const sonar = require('./controller/sonar')

// todo: 引入auth中间件
router
  .use(error())
  .use(proxy({
    agent: config.agent,
  }))
  .use(result())
  .use(validate())
  .use(qalog())
  .use('/proconfig', proconfig.routes())
  .use('/docker', docker.routes())
  .use('/user', user.routes())
  .use('/k8s', k8s.routes())
  .use('/indexurl', index.routes())
  .use('/dbconfig', dbconfig.routes())
  .use('/dbsync', dbsync.routes())
  .use('/binlog2sql', binlog2sql.routes())
  .use('/harborHook', harborHook.routes())
  .use('/log', log.routes())
  .use('/repo', repo.routes())
  .use('/repoNew', repoNew.routes())
  .use('/envTemplate', envTemplate.routes())
  .use('/env', env.routes())
  .use('/pipeline', pipeline.routes())
  .use('/resource', resource.routes())
  .use('/cluster', cluster.routes())
  .use('/notify', notify.routes())
  .use('/sonar', sonar.routes())

module.exports = router
