
const { Schema } = require('mongoose')

const schema = new Schema({
  dbname: {
    type: String, unique: true, required: true, index: true,
  },
  ip: { type: String, required: true },
  port: { type: Number, required: true },
  username: { type: String },
  passwd: { type: String },
  table_list: { type: String },
}, {
  versionKey: false,
  collection: 'dbconfigs', // 表名
  timestamps: true,
})

schema.statics.getDBConfig = function (query, column, sort) {
  return this.find(query, column).sort(sort)
}

schema.statics.getDBName = function () {
  return this.find({}, { _id: 0, dbname: 1 }).sort({ dbname: 1 })
}

schema.statics.getOne = function (query) {
  return this.findOne(query)
}

schema.statics.save = async function (doc) {
  if (doc._id) {
    delete doc.updatedAt
    return this.update({
      _id: doc._id,
    }, doc)
  }
  return this.create(doc)
}

schema.statics.delete = function (id) {
  return this.findByIdAndRemove(id)
}

module.exports = schema
