const axios = require('axios')

const config = {
  timeout: 10000,
}
const instance = axios.create(Object.assign({}, config))
instance._extend = {}

function requestInterceptor(config) {
  return config
}

function responseInterceptor(response) {
  if (response.status < 200 || response.status > 300) {
    return Promise.reject(response && response.data)
  }

  // 返回全部response
  if (response.config.rawResponse) {
    return Promise.resolve(response)
  }

  return Promise.resolve(response && response.data)
}

/**
 * 不使用默认拦截器
 *    axios.interceptors.request.eject(0)
 *    axios.interceptors.response.eject(0)
 */
instance.interceptors.request.use(requestInterceptor, error => Promise.reject(error))

instance.interceptors.response.use(responseInterceptor, error => Promise.reject(error))

module.exports = instance
