const Router = require('koa-router')

const bodyParser = require('koa-bodyparser')

const cproc = require('child_process')
const moment = require('moment')

const k8sService = require('../service/k8sService')

const config = require(global.configPath);
const { execSync } = cproc;

const { binlogDir } = config;

const getTimeRange = async function (ctx) {
  ctx.body = ctx.ok(['', 'Last 5 minutes', 'Last 15 minutes', 'Last 1 hour', 'Last 4 hours', 'Last 12 hours', 'Last 24 hours', 'all'])
};

const resetBinlog = async function (ctx) {
  const req = ctx.request.body;

  const rule = {
    name_space: 'required',
  };

  if (!ctx.validate(req, rule)) {
    ctx.body = ctx.fail(ctx.Code.ERROR_INPUT);
    return
  }

  const env = await k8sService.listEnvVars(req.name_space)
  const targetDBHost = env.DB_SERVICE_HOST
  const targetDBPort = env.DB_SERVICE_PORT


  cproc.exec(`mysql -h${targetDBHost} -P${targetDBPort} -uqa -pqatest -e "reset master"`);
  ctx.body = ctx.ok()
};

const binlog2Sql = async function (ctx) {
  const req = ctx.request.body;
  let dbName = req.db_name;
  if (dbName === 'all') {
    dbName = ''
  }
  const tables = req.tables || '';
  const timeRange = req.current_tiem_range;
  let starttime;
  let endtime = moment().format('YYYY-MM-DD HH:mm:ss');
  switch (timeRange) {
    case 'Last 5 minutes':
      starttime = moment().subtract(5, 'minutes').format('YYYY-MM-DD HH:mm:ss');
      break;
    case 'Last 15 minutes':
      starttime = moment().subtract(15, 'minutes').format('YYYY-MM-DD HH:mm:ss');
      break;
    case 'Last 1 hour':
      starttime = moment().subtract(1, 'hours').format('YYYY-MM-DD HH:mm:ss');
      break;
    case 'Last 4 hours':
      starttime = moment().subtract(4, 'hours').format('YYYY-MM-DD HH:mm:ss');
      break;
    case 'Last 12 hours':
      starttime = moment().subtract(12, 'hours').format('YYYY-MM-DD HH:mm:ss');
      break;
    case 'Last 24 hours':
      starttime = moment().subtract(1, 'days').format('YYYY-MM-DD HH:mm:ss');
      break;
    case 'all':
      starttime = '';
      endtime = '';
      break;
    default:
      break
  }

  const envVars = await k8sService.listEnvVars(req.name_space)

  const targetDBHost = envVars.DB_SERVICE_HOST
  const targetDBPort = envVars.DB_SERVICE_PORT


  let binlogFile = String(execSync(`mysql -h${targetDBHost} -P${targetDBPort} -uqa -pqatest -e "show master status" | grep bin`));
  binlogFile = binlogFile.split('\t')[0];

  const logFile = `${moment().valueOf()}_${req.name_space}_${req.db_name}`;

  const cmd = `python ${binlogDir}/binlog2sql.py  -h${targetDBHost} -P${targetDBPort} -uqa -pqatest -d${dbName}`
   + ` -t ${tables}  --start-file='${binlogFile}'  --start-datetime='${starttime}'  --stop-datetime='${endtime}'`
   + ` > ${binlogDir}/../logs/${logFile} `;

  // 异步
  cproc.exec(cmd);
  ctx.body = ctx.ok({ msg: { logFile, cmd } })
};

const binlog2sqlQuery = async function (ctx) {
  const req = ctx.request.body;
  let sql;
  const logFile = req.log_file;
  let cmd = `ps -ef | grep ${logFile} | grep -v grep`;
  try {
    execSync(cmd);
    ctx.body = ctx.ok({ status: 'running', msg: { sql: '请稍候~' } })
  } catch (error) {
    cmd = `cat ${binlogDir}/../logs/${logFile}`;
    sql = String(execSync(cmd));
    ctx.body = ctx.ok({ status: 'complete', msg: { sql, logFile } })
  }
};

const router = new Router();
router
  .use(bodyParser())
  .get('/get_time_range', getTimeRange)
  .post('/reset_binlog', resetBinlog)
  .post('/binlog_to_sql', binlog2Sql)
  .post('/binlog2sql_query', binlog2sqlQuery);

module.exports = router;
