const log = require('koa-log4').getLogger('service:etcd')
const Etcd = require('node-etcd')

const appConfig = require(global.configPath)

const etcd = new Etcd(appConfig.k8s.etcd)

const proxy = new Proxy(etcd, {
  get(target, property) {
    // 只代理函数调用
    // if (typeof target[property] === 'function' && etcd.client.hasOwnProperty(property)) {
    if (typeof target[property] === 'function' && Object.prototype.hasOwnProperty.call(etcd.client, property)) {
      return function (...args) {
        return new Promise(((resolve, reject) => {
          const cb = function (err, data) {
            if (err) {
              reject(err)
            } else {
              resolve(data)
            }
          }
          args.push(cb)
          etcd[property](...args)
        }))
      }
    }
  },
})

exports.getProgressOfNamespace = async function (namespace) {
  let progress = 'inited'
  try {
    const key = `/eos/progress/${namespace}/progress/msg`
    let res = await proxy.get(key)
    res = JSON.parse(res.node.value)
    progress = res.status
  } catch (e) { log.error(e) }
  return progress
}

exports.getHangUpEnv = async function () {
  const key = '/eos/hangup'
  const res = await proxy.get(key, { recursive: true })
  // let res = await etcd.get(key, { recursive: true }, console.log)
  return res
}

exports.getStatus = async function (namespace, name) {
  let status
  try {
    const key = `/eos/namespaces/${namespace}/${name}/status`
    const res = await proxy.get(key)
    status = res.node.value
  } catch (e) {
    log.info(e)
  }
  return status
}

exports.listPreset = async function () {
  const key = '/eos/preset'
  const res = await proxy.get(key)
  return res.node.nodes.map(item => JSON.parse(item.value))
}
