

const Router = require('koa-router')

const config = require(global.configPath)
const bodyParser = require('koa-bodyparser')
const logger = require('koa-log4').getLogger('router:harborHook')

const redisService = require('../service/redisService')

const endpoint = async function (ctx) {
  const { body } = ctx.request
  if (body && body.events) {
    const changes = body.events.filter(event => event.action === 'push').map(event => ({
      repository: event.target.repository,
      tag: event.target.tag,
    }))


    // 有新镜像时更新缓存，并只保留前 config.harborImageCache.size 个
    for (let i = 0; i < changes.length; i += 1) {
      const pipeline = redisService.pipeline()
      const key = `${config.harborImageCache.name}_${changes[i].repository}`
      if (changes[i].tag === 'latest') {
        await pipeline.lrem(key, 1, changes[i].tag).exec()
      }
      await pipeline.lpush(key, changes[i].tag)
        .ltrim(key, 0, config.harborImageCache.size - 1).exec()
    }
    logger.info(changes)
  }
  ctx.body = ctx.ok({})
}

const router = new Router()
router
  .use(bodyParser({
    extendTypes: {
      json: ['application/vnd.docker.distribution.events.v1+json'],
    },
  }))
  .post('/endpoint', endpoint)

module.exports = router
