const Router = require('koa-router')
const bodyParser = require('koa-bodyparser')
const { EnvTemplate } = require('../service/mongoService')

const router = new Router()
module.exports = router


const getAll = async (ctx) => {
  const item = await EnvTemplate.getTemplates({}, '-createdAt -updatedAt', { name: 1 })
  item.unshift({
    name: '空',
  })
  ctx.body = ctx.ok(item)
}

// 模板一般都是预制的，修改和删除需要改库
const create = async (ctx) => {
  const rule = {
    name: 'required',
  }
  const data = ctx.request.body
  if (!ctx.validate(data, rule)) {
    ctx.body = ctx.fail(ctx.Code.ERROR_INPUT)
    return
  }
  const ins = await EnvTemplate.getByName(ctx.request.body.name)
  if (ins) {
    ctx.body = ctx.fail('模板名称已存在')
    return
  }

  await EnvTemplate.save(ctx.request.body)
  ctx.body = ctx.ok()
}

const save = async (ctx) => {
  // const ins = await EnvTemplate.getByName(ctx.request.body.name)
  await EnvTemplate.save(ctx.request.body)
  ctx.body = ctx.ok()
}

const remove = async function (ctx) {
  const rule = {
    _id: 'required',
  }
  const data = ctx.request.query
  if (!ctx.validate(data, rule)) {
    ctx.body = ctx.fail(ctx.Code.ERROR_INPUT)
    return
  }
  const item = await EnvTemplate.delete(ctx.request.query._id)
  ctx.body = ctx.ok(item)
}

router
  .use(bodyParser())
  .get('/getAll', getAll)
  .post('/create', create)
  .post('/save', save)
  .get('/delete', remove)
