const Log = require('../../service/mongoService').StatisticsLog

module.exports = function () {
  return async function (ctx, next) {
    if (ctx.qalog) return next()

    ctx.qalog = {
      user: ctx.user && ctx.user.cn,
      user_mail: ctx.user && ctx.user.mail,
      detail: '',
      active: '',
      microservice_name: '',
      namespace: '',
      setActive(active) {
        this.active = active
      },
    }

    await next()
    if (!ctx.qalog.active) return false

    ctx.qalog.namespace = ctx.request.query.namespace || ctx.request.body.namespace || ''
    ctx.qalog.microservice_name = ctx.request.query.system_name || ctx.request.query.dbname || ctx.request.body.system_name || ''
    ctx.qalog.detail = ctx.request.body || {}

    await Log.saveLog(ctx.qalog)
  }
}
