const Redis = require('ioredis')

const config = require(global.configPath)
const log = require('koa-log4').getLogger('service:redis')

let client = null
let connect = ''
if (process.env.NODE_ENV === 'production') {
  client = new Redis({
    sentinels: config.redis.sentinels,
    name: 'mymaster',
  })
  connect = config.redis.sentinels
} else {
  client = new Redis({
    sentinels: config.redis.sentinels,
    name: 'mymaster',
  })
  connect = config.redis.sentinels
}

// 建立连接
client.on('error', (e) => {
  log.error(`error : connect redis ${connect} ${e}`)
})
client.on('ready', () => {
  log.info(`connect redis ${JSON.stringify(connect)} success!`)
})

module.exports = client

module.exports.flushMultiRedis = async function (configList) {
  const flush = async function (config) {
    const client = new Redis(config)
    await client.flushall()
    await client.quit()
  }

  const tasks = configList.map(item => flush(item))

  return Promise.all(tasks)
}
