const nodemailer = require('nodemailer')
const logger = require('koa-log4')
  .getLogger('sendMial')
const config = require('../../src')

const transporter = nodemailer.createTransport({
  host: config.email.service,
  port: 587,
  secure: false, // true for 465, false for other ports
  auth: {
    user: config.email.user,
    pass: config.email.pass,
  },
  tls: {
    // do not fail on invalid certs
    rejectUnauthorized: false,
  },
})

/**
 * @param {String} recipient 收件人
 * @param {String} subject 发送的主题
 * @param {String} html 发送的html内容
 */
module.exports = async function (recipient, subject, html) {
  const info = await transporter.sendMail({
    from: config.email.user,
    to: recipient,
    subject,
    html,
  })
  logger.info('邮件发送成功', info.envelope, html)
}
