const http = require('./httpService')

const config = require(global.configPath)
const mqApi = config.api.mq_api
const qaAuth = config.syncMq.auth

exports.getDefinitions = function () {
  return http.get(`${mqApi}/api/definitions`, { headers: { Authorization: 'Basic cmFiYml0X2FkbWluOmFiYzEyMzQ=' } })
}

// 获取容器环境中rabbitmq的定义信息
exports.getDefinitionsOfHost = function (host) {
  return http.get(`http://${host}/api/definitions`, { headers: { Authorization: qaAuth } })
}

exports.setDefinitions = function (host, data) {
  // 将rabbit_admin的权限同步给qa
  const permissions = data.permissions
  const tempPermissions = []
  permissions.forEach((item) => {
    if (item.user === 'rabbit_admin') {
      const tmp = JSON.stringify(item)
      const result = JSON.parse(tmp)
      result.user = 'qa'
      tempPermissions.push(item)
      tempPermissions.push(result)
    } else if (item.user !== 'qa' && item.user !== 'rabbit_admin') {
      tempPermissions.push(item)
    }
  })
  data.permissions = tempPermissions
  return http.post(`http://${host}/api/definitions`, data, {
    headers: {
      Authorization: qaAuth,
      'Content-Type': 'application/json',
    },
  })
}
