const { Schema } = require('mongoose')

// 表结构
const schema = new Schema({
  buildId: { type: Number },
  buildJob: { type: String },
  projectName: { type: String },
  branchName: { type: String },
  gitUser: { type: String },
  commitMes: { type: String },
  branchHash: {
    type: String, unique: true, required: true, index: true,
  },
  buildResult: { type: String },
  sonarResult: { type: String },
  analysisDate: { type: String },
}, {
  versionKey: false,
  collection: 'sonarJob', // 表名
  timestamps: true,
})

schema.statics.saveSonarJob = function (doc) {
  return this.create(doc)
}

schema.statics.updateSonarJob = function (doc) {
  return this.updateOne({
    branchHash: doc.branchHash,
  }, doc)
}

schema.statics.getOneSonarJob = function (query) {
  return this.findOne(query, { _id: 0 })
}

schema.statics.getSonarJob = function (query, column, sort, page) {
  return this.find(query, column).sort(sort).skip(page.num * page.count).limit(page.count)
    .lean()
}

schema.statics.getSonarJobCount = function (query) {
  return this.find(query).countDocuments()
}

schema.statics.getSonarJobGroup = function (query) {
  return this.aggregate([
    { $match: query },
    // { $match: { sonarResult: 'WARN' } },
    {
      $group: {
        _id: '$projectName',
        result: {
          $push: { sonarResult: '$sonarResult', buildResult: '$buildResult', updatedAt: '$updatedAt' },
        },
      },
    },
  ])
}

module.exports = schema
