
const { Schema } = require('mongoose')

// const initPort = 7000

// 表结构
const schema = new Schema({
  buildId: { type: Number },
  buildJob: { type: String },
  branchName: { type: String },
  commitMes: { type: String },
  gitUser: { type: String },
  gitEventTime: { type: String },
  projectName: { type: String },
  objectKind: { type: String },
  type: { type: String },
}, {
  versionKey: false,
  collection: 'pipelinePush', // 表名
  timestamps: true,
})
schema.statics.savePipesPush = function (doc) {
  return this.create(doc)
}
schema.statics.getPipesPush = function (data) {
  return this.find(data).sort({ createdAt: 1 })
}
schema.statics.getOnePipePush = function (data) {
  return this.findOne(data)
}
module.exports = schema
