
const { Schema } = require('mongoose')

// 表结构
const schema = new Schema({
  clusterName: { type: String },
  clusterDomain: { type: String },
  clusterCA: { type: Object },
  hosts: { type: Array },
  disable: { type: String },
}, {
  versionKey: false,
  collection: 'cluster', // 表名
  timestamps: true,
})
schema.statics.saveCluster = function (doc) {
  if (doc._id) {
    return this.update({
      _id: doc._id,
    }, doc)
  }
  return this.create(doc)
}
schema.statics.updateCluster = function (doc) {
  return this.update(doc)
}
schema.statics.getCluster = function (doc) {
  if (doc.clusterName) {
    return this.find(doc)
  }
  return this.find({ disable: 1 })
}
// schema.statics.deleteCluster = function (id) {
//   return this.findByIdAndRemove(id)
// }
schema.statics.deleteCluster = function (id) {
  return this.update({ _id: id }, { $set: { disable: 0 } })
}
module.exports = schema
