const schedule = require('node-schedule')
const logger = require('koa-log4').getLogger('jobs:calculation memory')
const moment = require('moment')
const awaitRequest = require('../utils/awaitRequest')
const { MemoryResource } = require('../service/mongoService')

const config = require(global.configPath)

async function job() {
  logger.info('memory rate job start')
  const finalMemoryLimit = {}
  const memoryLimitRes = await awaitRequest({
    url: `${config.prometheus}/api/v1/query?query=sum%20(container_spec_memory_limit_bytes%20{pod=~%22^()()().*$%22,
      namespace!~%22kube-system|monitor|rc-test%22}/(1024*1024))%20by%20(pod_name)`,
    method: 'GET',
  })
  memoryLimitRes.data.result.forEach((item) => {
    if (item.metric.pod_name) {
      finalMemoryLimit[item.metric.pod_name] = item.value[1]
    }
  })

  const finalMemoryUsage = {}
  const memoryUsageRes = await awaitRequest({
    url: `${config.prometheus}/api/v1/query?query=sum (container_memory_max_usage_bytes
      {id!="/",pod_name=~"^()()().*$"}/(1024*1024)) by (pod_name)`,
    method: 'GET',
  })
  memoryUsageRes.data.result.forEach((item) => {
    if (item.metric.pod_name) {
      finalMemoryUsage[item.metric.pod_name] = item.value[1]
    }
  })

  Object.keys(finalMemoryLimit).forEach((item) => {
    const data = {
      name: item,
      memoryLimit: Math.round(finalMemoryLimit[item]),
      memoryMaxUsage: Math.round(finalMemoryUsage[item]),
      Percentage: `${(finalMemoryUsage[item] / finalMemoryLimit[item]).toFixed(4)}`,
    }
    MemoryResource.saveMemory(data)
  })

  const dingdingMessage = {
    msgtype: 'link',
    link: {
      title: '内存统计已同步更新到qa-home下的resource目录，点击可查看详情',
      text: `内存统计告知:${moment().format('YYYY-MM-DD HH:mm:ss')}`,
      messageUrl: `${config.qahomeHost}/resources/memory`,
    },
  }
  await awaitRequest({
    url: config.dingdingResouce,
    method: 'POST',
    headers: {
      'Content-Type': 'application/json;charset=utf-8',
    },
    body: JSON.stringify(dingdingMessage),
  })
  logger.info('memory rate job end')
}
// module.exports = schedule.scheduleJob('*/2 * * * ?', async () => {
module.exports = schedule.scheduleJob('0 0 20 * * ?', async () => {
  try {
    job()
  } catch (e) {
    logger.info('calculation memory', e)
  }
})
