const Router = require('koa-router')
const logger = require('koa-log4').getLogger()
const bodyParser = require('koa-bodyparser')
const ProConfig = require('../service/mongoService').ProConfig
const repoServiceNew = require('../service/repoServiceNew')

const router = new Router()
module.exports = router

const QA = 'qa-'
const BASETYPE = 'base'
const QABASE = 'qa-base'
const QATEST = 'qa-test'

const formatData = (obj) => {
  const data = []
  // eslint-disable-next-line guard-for-in
  for (const i in obj) {
    data.push({
      type: i,
      repos: obj[i],
    })
  }
  data.sort((a, b) => (a.type > b.type ? 1 : -1))
  return data
}

const getAllRepos = async (ctx) => {
  const ns = [{ namespace: QATEST }, { namespace: QABASE }]
  ctx._domains = await ProConfig.getActiveProjectsHostName()

  const task = []
  for (let i = 0; i < ns.length; i += 1) {
    logger.info('要查询的namespace:', ns[i])
    ns[i].type = ns[i].namespace.replace(QA, '')
    task.push(repoServiceNew.getRepoOfNs(ctx, ns[i]))
  }
  await Promise.all(task)

  const obj = {}
  for (const n of ns) {
    if (n.type === BASETYPE) {
      obj[n.type] = n.repos
    } else {
      for (const repo of n.repos) {
        if (!obj[repo.type]) obj[repo.type] = []
        obj[repo.type].push(repo)
      }
    }
  }

  const data = formatData(obj)
  ctx.body = ctx.ok(data)
}

const getBaseRepos = async (ctx) => {
  const ns = {
    type: BASETYPE,
    namespace: QABASE,
  }
  await repoServiceNew.getRepoOfNs(ctx, ns)
  ctx.body = ctx.ok([ns])
}

const getAppRepos = async (ctx) => {
  const ns = { namespace: QATEST }
  ctx._domains = await ProConfig.getActiveProjectsHostName()
  await repoServiceNew.getRepoOfNs(ctx, ns)

  const obj = {}
  for (const repo of ns.repos) {
    if (!obj[repo.type]) obj[repo.type] = []
    obj[repo.type].push(repo)
  }
  const data = formatData(obj)
  ctx.body = ctx.ok(data)
}

const getSingleTypeApp = async (ctx) => {
  let data = []
  const ns = { namespace: ctx.request.body.namespace }
  ctx._domains = await ProConfig.getActiveProjectsHostName()
  await repoServiceNew.getRepoOfNs(ctx, ns)
  for (const repo of ns.repos) {
    if (repo.label === ctx.request.body.type) {
      data.push(repo)
    }
  }
  // qa-base 需要去重
  if (ctx.request.body.type === 'base') {
    const obj = {}
    data = data.reduce((a, b) => {
      obj[b.type] ? '' : obj[b.type] = true && a.push(b)
      return a
    }, [])
  }
  ctx.body = ctx.ok(data)
}

router
  .use(bodyParser())
  .get('/getAll', getAllRepos)
  .get('/getBase', getBaseRepos)
  .get('/getApp', getAppRepos)
  .post('/getSingleTypeApp', getSingleTypeApp)
