const Validator = require('Validator')


module.exports = function () {
  const messages = {
    required: ':attr不能为空',
    // custom message for specific rule of attribute
    // 'receiver.email': 'The receiver email address is not valid'
  }
  return function (ctx, next) {
    if (ctx.validate) return next()

    ctx.validate = function (data, rules) {
      const v = Validator.make(data, rules, messages)
      return v.passes()
    }

    return next()
  }
}
