const mongoose = require('mongoose')
const log = require('koa-log4').getLogger('service:mongo')

const config = require(global.configPath)
const path = require('path')

mongoose.Promise = global.Promise

// 创建数据库连接
const db = mongoose.createConnection(config.mongo.api, {
  autoReconnect: true,
  poolSize: 5,
  connectTimeoutMS: 60000,
  socketTimeoutMS: 60000,
  useNewUrlParser: true,
  config: {
    autoIndex: false,
  },
  // useMongoClient: true
})

db.on('error', (err) => {
  log.error(`error: connect ${config.mongo.api} ${err}`)
})

db.once('open', () => {
  log.info(`connect ${config.mongo.api} success!`)
})

const schemas = require('require-all')({
  dirname: path.resolve(__dirname, '../model/mongo/qa_api'),
})

const models = {}
for (const prop in schemas) {
  if (Object.prototype.hasOwnProperty.call(schemas, prop)) {
    models[prop] = db.model(prop, schemas[prop])
  }
}
module.exports = models
