

const LdapAuth = require('ldapauth-fork')
const logger = require('koa-log4').getLogger('authenticate')

const config = require(global.configPath)

/**
 * 普通认证，用户名和密码
 */
exports.base = async function (name, password, model) {
  return model.getUserByPwd(name, password, '-create_date -update_date')
}

/**
 * ldap认证
 * @param ctx
 * @returns {Promise.<void>}
 */
exports.ldap = async function (name, password) {
  return new Promise((resolve) => {
    const ldap = new LdapAuth(config.ldap)
    ldap.authenticate(name, password, (err, user) => {
      if (err) {
        logger.error(`name:${name},password:${password} error:${err}`)
        return resolve(null)
      }
      resolve(user)
    })
  })
}
