
const { Schema } = require('mongoose')

// 表结构
const schema = new Schema({
  name: { type: String },
  cpuLimit: { type: Number },
  cpuMaxUsage: { type: Number },
  Percentage: { type: Number },
}, {
  versionKey: false,
  collection: 'cpuResource', // 表名
  timestamps: true,
})
schema.statics.saveCpu = function (doc) {
  return this.create(doc)
}
schema.statics.updateCpu = function (doc) {
  return this.update(doc)
}
schema.statics.getCpu = function (start, end) {
  return this.aggregate([
    {
      $match: {
        createdAt: { $gte: new Date(new Date(start).toISOString()), $lt: new Date(new Date(end).toISOString()) },
      },
    },
    {
      $group: {
        _id: '$name',
        cpuLimit: { $max: '$cpuLimit' },
        cpuMaxUsage: { $max: '$cpuMaxUsage' },
        Percentage: { $max: '$Percentage' },
      },
    }, {
      $sort: {
        Percentage: 1,
      },
    }])
}

schema.statics.getCpu2 = function (query, column, sort) {
  if (query.name) {
    query.name = new RegExp(query.name)
  } else {
    delete query.name
  }
  return this.find(query, column).sort(sort).lean()
}

module.exports = schema
