
const { Schema } = require('mongoose')

const schema = new Schema({
  name_space: { type: String, unique: true, required: true },
  group: { type: String, required: true },
}, {
  versionKey: false,
  collection: 'namespacegroups', // 表名
  timestamps: true,
})

schema.statics.getGroups = function () {
  return this.find({}).lean()
}

schema.statics.save = async function (doc) {
  const item = await this.findOne({ name_space: doc.name_space })
  if (item) {
    return this.update({
      name_space: doc.name_space,
    }, doc)
  }
  return this.create(doc)
}

module.exports = schema
