
const config = require(global.configPath)
const client = require('../../service/redisService')

/**
 * 生成redis操作方法
 * @param {string} app context
 * @param {object} options 配置项
 *        {stirng} options.connect mongo连接路径
 * @return {function}
 *
 * @todo 增加测试用例
 */
module.exports = function graceRedis() {
  return async function redis(ctx, next) {
    if (ctx.redisGet) return next()

    Object.assign(ctx, {
      redisGet(key, id) {
        const redisKey = key + id || ''
        return client.get(redisKey).then((str) => {
          if (str) return JSON.parse(str)
          return null
        })
      },
      redisSet(key, id, data, option) {
        const redisKey = key + id
        const expire = (option && option.expire) || config.QA_TOKEN_EXPIRE
        client.set(redisKey, JSON.stringify(data))
        client.expire(redisKey, expire)
      },
      redisRemove(key, id) {
        client.del(key + id)
      },
    })

    await next()
  }
}
