
const { Schema } = require('mongoose')

// const initPort = 7000

// 表结构
const schema = new Schema({
  cluster: { type: String },
  namespace: { type: String },
  application_name: { type: String, required: true },
  repos: { type: Array, required: true },
  new_user: { type: String },
  isDeploy: { type: Boolean, required: true },
  noticeAddress: { type: String },
  noticeType: { type: String },
  update_user: { type: String },
  des: { type: String },
}, {
  versionKey: false,
  collection: 'pipeline', // 表名
  timestamps: true,
})
schema.statics.savePipes = function (doc) {
  if (doc._id) {
    delete doc.updatedAt
    return this.updateOne({
      _id: doc._id,
    }, doc)
  }
  return this.create(doc)
}
schema.statics.getPipes = function (data) {
  data.application_name = new RegExp(data.application_name)
  data.new_user = new RegExp(data.new_user)
  return this.find(data).sort({ updatedAt: -1 })
}
schema.statics.getMatchPipe = function (name) {
  return this.find({ repos: { $elemMatch: { repository: name } } }).sort({ updatedAt: 1 })
}
schema.statics.delete = function (id) {
  return this.findByIdAndRemove(id)
}
module.exports = schema
