
const Koa = require('koa')
const path = require('path')
const compress = require('koa-compress')
const cors = require('kcors')
const log4js = require('koa-log4')
global.Promise = require('bluebird')

global.configPath = path.resolve(__dirname, '../src')
const config = require(global.configPath)
global.config = config
const redis = require('../app/middleware/redis')
const auth = require('../app/middleware/auth')
require('../app/jobs/cpuRate')
require('../app/jobs/memoryRate')
require('../app/jobs/recovery')
require('../app/jobs/sonarCheck')

log4js.configure(config.log4js)
const logger = log4js.getLogger()

require('../app/service/mongoService')
require('../app/service/redisService')
// require('../app/jobs')

const logFormat = ':req[x-real-ip] :req[x-forwarded-for] - -'
    + ' ":method :url HTTP/:http-version"'
    + ' :status :content-length ":referrer"'
    + ' ":user-agent" :req[x-auth-token] :response-timems'

const router = require('../app')

const app = new Koa()

app
  .use(compress({
    threshold: 2048,
  }))
  .use(cors({
    maxAge: 86400, // options请求缓存24小时
    origin(req) {
      return req.header.origin
    },
    credentials: true,
  }))
  .use(log4js.koaLogger(log4js.getLogger('http'), { level: 'auto', format: logFormat }))
  .use(redis())
  .use(auth())
  .use(router.routes())

  .use(router.allowedMethods())
  .listen(config.port)

logger.info(`server listening ${config.port}`)
logger.info('加载环境配置: ', process.env.NODE_ENV)
