const http = require('./httpService')

const config = require(global.configPath)
const eosApi = config.api.eos_api
const harborApi = config.api.harbor_api

// exports.listEnv = function () {
//   return http.get(`${eosApi}/api/qahome/list_env`)
// }

exports.hang = function (data) {
  return http.post(`${eosApi}/api/qahome/hang_up_env`, data)
}

exports.recoveryHang = function (data) {
  return http.post(`${eosApi}/api/qahome/recovery_hang_up_env`, data)
}

exports.destroyHangUpEnv = function (data) {
  return http.delete(`${eosApi}/api/qahome/destroy_hang_up_env`, { data })
}

// exports.listEnvVars = function (namespace) {
//   return http.get(`${eosApi}/api/apollo/env_vars?namespace=${namespace}`)
// }

// exports.listHang = function () {
//   return http.get(`${eosApi}/api/qahome/list_hang_up_env`)
// }

// exports.listMicroService = function (namespace) {
//   return http.get(`${eosApi}/api/qahome/list_microservice?namespace=${namespace}`)
// }

// exports.listImage = function (systemName) {
//   return http.get(`${eosApi}/api/qahome/list_images?microservice_name=${systemName}`)
// }

// exports.getMicroService = function (namespace, systemName) {
//   return http.get(
//   `${eosApi}/api/qahome/get_microservice?namespace=${namespace}&name=${systemName}`)
// }

exports.createMicroService = function (data) {
  data.image = `${harborApi}${data.image}`
  return http.post(`${eosApi}/api/qahome/create_microservice`, data)
}

exports.updateMicroService = function (data) {
  data.image = `${harborApi}${data.image}`
  return http.put(`${eosApi}/api/qahome/update_microservice`, data)
}

exports.updateHost = function (data) {
  return http.put(`${eosApi}/api/qahome/update_microservice`, data)
}

exports.restartMicroService = function (data) {
  return http.post(`${eosApi}/api/qahome/restart_microservice`, data)
}

exports.deleteMicroService = function (data) {
  return http.delete(`${eosApi}/api/qahome/delete_microservice`, { data })
}

// exports.listPreset = function () {
//   return http.get(`${eosApi}/api/qahome/list_preset`)
// }

exports.savePreset = function (data) {
  return http.post(`${eosApi}/api/qahome/save_preset`, data)
}

exports.deletePreset = function (data) {
  return http.delete(`${eosApi}/api/qahome/delete_preset`, { data })
}

exports.initEnv = function (data) {
  return http.post(`${eosApi}/api/qahome/init_env`, data)
}

exports.destroyEnv = function (data) {
  return http.delete(`${eosApi}/api/qahome/destroy_env`, {
    data,
  })
}
