
const { Schema } = require('mongoose')

const schema = new Schema({
  url: { type: String, unique: true, required: true },
  type: { type: String, required: true },
  type_name: { type: String },
  remark: { type: String, required: true },
}, {
  versionKey: false,
  collection: 'indexurls', // 表名
  timestamps: true,
})

schema.statics.getIndexUrl = function (query) {
  return this.find(query).sort()
}

schema.statics.save = function (doc) {
  if (doc._id) {
    return this.update({
      _id: doc._id,
    }, doc)
  }
  return this.create(doc)
}

schema.statics.getType = async function (typeName) {
  const type = await this.findOne({ type_name: typeName }, { type: 1, _id: 0 })
  return type.type
}

schema.statics.delete = function (id) {
  return this.findByIdAndRemove(id)
}

module.exports = schema
