const Router = require('koa-router');
const bodyParser = require('koa-bodyparser')
const config = require('../../src');
const { StatisticsLog } = require('../service/mongoService');

const api = async function (ctx) {
  await ctx.pipe({
    uri: config.api.tke_api + ctx.url.replace('/k8s', ''),
  })
  if (ctx.request.method === 'POST' && ctx.response.status === 200 && ctx.request.url.indexOf('/service') !== -1) {
    const user = await ctx.redisGet(config.QA_TOKEN, ctx.request.header['x-token'])
    if (user) {
      const body = ctx.request.body
      const data = {
        namespace: body.namespace,
        active: ctx.request.url.replace('/k8s/', '').replace('/', '_'),
        microservice_name: body.serviceName,
        user: user.cn,
        user_mail: user.mail,
        detail: body,
      }
      await StatisticsLog.saveLog(data);
    }
  }
}
const router = new Router();

router
  .use(bodyParser())
  .get('/*', api)
  .post('/*', api)
module.exports = router
