const http = require('./httpService')

const config = require(global.configPath)
const mqApi = config.api.mq_api
const qaAuth = config.syncMq.auth

exports.getDefinitions = function () {
  return http.get(`${mqApi}/api/definitions`, { headers: { Authorization: 'Basic cmFiYml0X2FkbWluOmFiYzEyMzQ=' } })
}

// 获取容器环境中rabbitmq的定义信息
exports.getDefinitionsOfHost = function (host) {
  return http.get(`http://${host}/api/definitions`, { headers: { Authorization: qaAuth } })
}

exports.setDefinitions = function (host, data) {
  // 将rabbit_admin的权限同步给qa
  let permissions = data.permissions
  var temp_permissions = []
  permissions.forEach(item => {
    if (item.user === 'rabbit_admin') {
      let tmp = JSON.stringify(item)
      let result = JSON.parse(tmp)
      result.user = 'qa'
      temp_permissions.push(item)
      temp_permissions.push(result)
    } else if (item.user !== 'qa' && item.user !== 'rabbit_admin') {
      temp_permissions.push(item)
    }
  })
  data.permissions = temp_permissions
  return http.post(`http://${host}/api/definitions`, data, {
    headers: {
      Authorization: qaAuth,
      'Content-Type': 'application/json',
    },
  })
}
