const Router = require('koa-router')
const bodyParser = require('koa-bodyparser');
const { Notify } = require('../service/mongoService');

const save = async (ctx) => {
  const data = ctx.request.body;

  const rule = {
    content: 'required',
  };

  if (!ctx.validate(data, rule)) {
    ctx.body = ctx.fail(ctx.Code.ERROR_INPUT);
    return
  }

  await Notify.save(data);
  ctx.body = ctx.ok()
};

const getNotify = async (ctx) => {
  const item = await Notify.getNotify(ctx.request.body);
  ctx.body = ctx.ok(item)
}

const remove = async function (ctx) {
  const rule = {
    _id: 'required',
  }
  const data = ctx.request.query
  if (!ctx.validate(data, rule)) {
    ctx.body = ctx.fail(ctx.Code.ERROR_INPUT)
    return
  }
  const item = await Notify.delete(ctx.request.query._id)
  ctx.body = ctx.ok(item)
}

const router = new Router();
router
  .post('/getNotify', bodyParser(), getNotify)
  .post('/save', bodyParser(), save)
  .get('/delete', remove)

module.exports = router;
