
const Router = require('koa-router');
const bodyParser = require('koa-bodyparser');
const { DBConfig } = require('../service/mongoService');

const config = require('../../src/');

const { defaultUsername, defaultPasswd } = config.syncDB;

const getDBConfig = async (ctx) => {
  const item = await DBConfig.getDBConfig({}, {}, { dbname: 1 });
  for (const db of item) {
    if (db.username === defaultUsername) {
      db.username = ''
    }
    if (db.passwd === defaultPasswd) {
      db.passwd = ''
    }
  }
  ctx.body = ctx.ok(item)
};

const save = async (ctx) => {
  const data = ctx.request.body;

  const rule = {
    dbname: 'required',
    ip: 'required',
    port: 'required',
  };

  if (!ctx.validate(data, rule)) {
    ctx.body = ctx.fail(ctx.Code.ERROR_INPUT);
    return
  }

  const re = /^[a-zA-Z0-9 _]*$/;
  if (!re.test(data.table_list)) {
    ctx.body = ctx.fail('表名与表名请使用空格进行分隔');
    return
  }

  for (const prop in data) {
    if (Object.prototype.hasOwnProperty.call(data, prop)) {
      if (typeof data[prop] === 'string' && data[prop].length) {
        data[prop] = data[prop].trim()
      }
      if (prop === 'username' && data[prop] === '') {
        data[prop] = defaultUsername
      }
      if (prop === 'passwd' && data[prop] === '') {
        data[prop] = defaultPasswd
      }
    }
  }

  // 处理多个空格
  data.table_list = data.table_list.split(/ +/).join(' ')

  // let db = await DBConfig.getOne({ "_id": data._id })
  // if (db && db.updatedAt && JSON.stringify(db.updatedAt).replace(/"/g, '') !== data.updatedAt) {
  //     ctx.body = ctx.fail('停留时间太长导致时间戳不正确，请刷新后再试~')
  //     return
  // }

  await DBConfig.save(data);
  ctx.body = ctx.ok()
};

const remove = async (ctx) => {
  const data = ctx.request.query;
  const rule = {
    _id: 'required',
  };
  if (!ctx.validate(data, rule)) {
    ctx.body = ctx.fail(ctx.Code.ERROR_INPUT);
    return
  }
  const item = await DBConfig.delete(data._id);
  ctx.body = ctx.ok(item)
};

const router = new Router();
router
  .get('/get_db_config', getDBConfig)
  .post('/save', bodyParser(), save)
  .get('/delete', remove);

module.exports = router;
