const schedule = require('node-schedule')
const logger = require('koa-log4').getLogger('dailySonarCheck')
const { ProConfig } = require('../service/mongoService')
const jenkinsService = require('../service/jenkinsService')
const sleep = require('../utils/sleep')

const sonarCheck = async () => {
  logger.info('daily sonarCheck start')

  let projects = await ProConfig.findByQuery({ is_active: true, type: 'java', deploy_to_testenv: true },
    { project_name: 1 }, { project_name: 1 })
  projects = projects.map(i => i.project_name)
  logger.info('要扫描的项目', projects)

  // // for test
  // const testProject = ['acs-batch', 'cash-loan-flow']
  // projects = projects.filter(item => testProject.includes(item))
  for (const project of projects) {
    const data = {
      GIT_REPO: project,
      BRANCH_NAME: 'master',
      FORCE_SCAN: 'noMail',
    }
    jenkinsService.build_with_params('tke-sonar', data)
    logger.info('daily sonarCheck', data)
    await sleep(15 * 1000)
  }
  logger.info('daily sonarCheck end')
}

module.exports = schedule.scheduleJob('30 21 * * *', async () => {
  try {
    await sonarCheck()
  } catch (e) {
    logger.info('daily sonarCheck', e)
  }
});
