from model_data_api.model.base_model import BaseManager
from model_data_api.model.tab_model import TabFeatureData
from model_data_api.model.tab_model import TabAssertData
import datetime
#
class FeatureDataManager(BaseManager):
    def find_all(self):
        return self.get_json(self.session.query(TabFeatureData).all())

    def find_single(self, feature_name):
        return self.get_json(self.session.query(TabFeatureData).filter_by(feature_name=feature_name))

    def find_single_assert(self,assert_name):
        result = []
        query = self.session.query(TabAssertData.assert_name,TabAssertData.assert_content,
                                   TabAssertData.assert_type,TabAssertData.assert_value,
                                   TabAssertData.assert_gdp,TabAssertData.data_type,TabAssertData.data_round
                                   ).filter_by(assert_name=assert_name)

        for i ,res in enumerate(query):
            print('feature res===',res)
            result.append(dict(zip(res.keys(),list(res))))
            print('feature result===',result)

        return result

    def find_condition(self, **kwargs):
        return self.session.query(TabFeatureData).filter(**kwargs)

    def update_obj(self, feature_name):
        # p = []
        self.session.query(TabFeatureData).filter(TabFeatureData.feature_name==feature_name,TabFeatureData.is_active==1).update({TabFeatureData.is_active:2,TabFeatureData.update_at:datetime.datetime.now()})
        self.session.commit()

    def create_obj(self,data):
        p = []
        for v in data:
            l_featrue = self.find_single(v['feature_name'])
            if l_featrue:
                self.update_obj(v['feature_name'])
            p.append(
                    TabFeatureData(feature_name = v['feature_name'],
                                   feature_content =v['feature_content'],
                                   feature_type =v['assert_type'],
                                   feature_value =v['assert_value'],
                                   feature_gdp =v['assert_gdp'],
                                   data_type = v['data_type'],
                                   data_round = v['data_round']
                                ))
        self.session.add_all(p)
        self.session.commit()

        # p = TabFeatureData(feature_name=name,feature_content=content)
        # self.session.add(p)
        # self.update_obj()
