# -*- coding:utf-8 -*-

from sqlalchemy import Column, String, Integer,Index,TIMESTAMP,ForeignKey,UniqueConstraint,SMALLINT,SmallInteger
from sqlalchemy.dialects.mysql import LONGTEXT
import datetime
from model_data_api.config import *

db_base = DB_Base()
class BaseTable(db_base):
    __table_args__ = {
        "mysql_charset" : "utf8"
    }
    __abstract__ = True


class TabModelsData(BaseTable):
    __tablename__ = "models_datail"

    id = Column(Integer, primary_key=True, autoincrement=True)
    name = Column(String(255),comment='模型名称',primary_key=True,index=True)
    content = Column(String(150),comment='描述')
    create_name = Column(String(150),comment='创建人')
    el_expression = Column(String(150),comment='el表达式')
    create_at = Column(TIMESTAMP,default=datetime.datetime.now(),comment='创建时间')
    update_at = Column(TIMESTAMP,default=datetime.datetime.now(),comment='更新时间')

    def __repr__(self):
        return {
            'model_id': int(self.id),
            'model_name': self.name,
            'model_content': self.content,
            'create_name': self.create_name,
            'el_expression': self.el_expression,
            'create_at' : self.create_at,
            'update_at' : self.update_at,
        }

class TabFeatureData(BaseTable):

    __tablename__ = "feature_detail"
    id = Column(Integer, primary_key=True, autoincrement=True)
    feature_name = Column(String(255),comment='特征名称',index=True, nullable=True)
    feature_content = Column(String(150),comment='描述')
    feature_type = Column(String(150),comment='类型')
    feature_value = Column(String(150),comment='校验匹配规则',default=None)
    feature_gdp = Column(Integer,comment='占比')
    data_type = Column(SmallInteger,comment="feature_value 数据类型 ,0 无值, 1 正数, 2 小数",default=0)
    data_round = Column(SmallInteger,comment="feature_value 保留小数位数 ,0 无值 ,其他值表示小数点的位数",default=0)
    is_active = Column(SmallInteger,comment="是否在用 1 在用 2 不在用",default=1)
    create_at = Column(TIMESTAMP,default=datetime.datetime.now(),comment='创建时间')
    update_at = Column(TIMESTAMP,default=datetime.datetime.now(),comment='更新时间')

    # def __repr__(self):
    #     return '<feature_detail(id=%s,feature_name=%s,feature_content=%s,feature_asserts=%s)>' \
    #            % (self.id,self.feature_name,self.feature_content,self.feature_asserts)
    def __repr__(self):
        return {
            'feature_id': self.id,
            'feature_name': self.feature_name,
            'feature_content': self.feature_content,
            'feature_type': self.feature_type,
            'feature_value': self.feature_value,
            'feature_gdp' : self.feature_gdp,
            'data_type' : self.data_type,
            'data_round' : self.data_round,
            'is_active':self.is_active,
            'create_at' : self.create_at,
            'update_at' : self.update_at,
        }

class TabAssertData(BaseTable):
    """数据验证表"""
    __tablename__ = "assert_datail"
    id = Column(Integer, primary_key=True, autoincrement=True)
    assert_name = Column(String(32),comment='集合名称')
    assert_content = Column(String(150),comment='描述')
    assert_type = Column(String(150),comment='类型')
    assert_value = Column(String(150),comment='校验匹配规则',default=None)
    assert_gdp = Column(Integer,comment='占比')
    data_type = Column(SmallInteger,comment="feature_value 数据类型 ,0 无值, 1 正数, 2 小数",default=0)
    data_round = Column(SmallInteger,comment="feature_value 保留小数位数 ,0 无值 ,其他值表示小数点的位数",default=0)

    create_at = Column(TIMESTAMP,default=datetime.datetime.now(),comment='创建时间')
    update_at = Column(TIMESTAMP,default=datetime.datetime.now(),comment='更新时间')


    def __repr__(self):
        return {
            'id': self.id,
            'assert_name': self.assert_name,
            'assert_content': self.assert_content,
            'assert_type': self.assert_type,
            'assert_value': self.assert_value,
            'assert_gdp': self.assert_gdp,
            'data_type': self.data_type,
            'data_round': self.data_round,
            'create_at' : self.create_at,
            'update_at' : self.update_at,
        }

class TabDataSet(BaseTable):
    """数据集合表"""
    __tablename__ = "data_set"
    id = Column(Integer, primary_key=True, autoincrement=True)
    model_name = Column(String(255),ForeignKey("models_datail.name"))
    user_count = Column(Integer)
    feature_name = Column(String(255), ForeignKey("feature_detail.feature_name"))

    create_at = Column(TIMESTAMP,default=datetime.datetime.now(),comment='创建时间')
    update_at = Column(TIMESTAMP,default=datetime.datetime.now(),comment='更新时间')

    def __repr__(self):
        return {
            'id': self.id,
            # 'model_id': self.model_id,
            'model_name': self.model_name,
            'user_count': self.user_count,
            'feature_name': self.feature_name,
            'create_at' : self.create_at,
            'update_at' : self.update_at,
        }

class TabDataSetDatail(BaseTable):
    """数据明细表"""
    __tablename__ = "data_set_datail"
    id = Column(Integer, primary_key=True, autoincrement=True)

    model_id = Column(Integer, ForeignKey("models_datail.id"),comment="模型ID")
    model_name = Column(String(255),ForeignKey("models_datail.name"))
    user_count = Column(Integer,comment="生成用户总数")
    # batch_uuid = Column(String(255),comment="加密后的ID")
    # feature_id = Column(Integer, ForeignKey("feature_detail.id"))
    feature_name = Column(LONGTEXT,comment="特征名称,list")
    # request = Column(String(255),comment="接口地址")
    report_type = Column(SMALLINT,comment="1 模型结构, 2 特征明细 ,3 测试报告")
    data_path = Column(String(255),comment='数据地址')
    create_at = Column(TIMESTAMP,default=datetime.datetime.now(),comment='创建时间')
    update_at = Column(TIMESTAMP,default=datetime.datetime.now(),comment='更新时间')
#
    def __repr__(self):
        return {
            'id': self.id,
            'model_id': int(self.model_id),
            'model_name': self.model_name,
            'user_count': self.user_count,
            'feature_name': self.feature_name,
            'report_type' : self.report_type,
            'data_path' : self.data_path,
            'create_at' : self.create_at,
            'update_at' : self.update_at,
        }

class TabUserTest(BaseTable):
    """数据明细表"""
    __tablename__ = "user_test"
    id = Column(Integer, primary_key=True, autoincrement=True)
    data_set_datail_id = Column(Integer, ForeignKey("data_set_datail.id"),comment="模型ID")  #
    model_name = Column(String(255),ForeignKey("models_datail.name"))
    batch_uuid = Column(String(255),comment="加密后的ID")
    data_detail = Column(LONGTEXT,comment="返回体")

    # create_at = Column(TIMESTAMP,default=datetime.datetime.now(),comment='创建时间')
    # update_at = Column(TIMESTAMP,default=datetime.datetime.now(),comment='更新时间')
    # #
    def __repr__(self):
        return {
            'id': self.id,
            'data_set_datail_id': int(self.data_set_datail_id),
            'model_name': self.model_name,
            'batch_uuid': self.batch_uuid,
            'data_detail': self.data_detail,
            # 'create_at' : self.create_at,
            # 'update_at' : self.update_at
        }



        #'<data_set_datail(id=%d,model_id=%d,model_name=%s,user_count=%d,feature_name=%s,data_path=%s)>' \
    #            % (self.id,self.model_id,self.model_name,self.user_count,str(self.feature_name),self.data_path)





#
# db_base.metadata.drop_all(bind=create_engine(settings.DB_CONNECT_STRING['model_db']))
# db_base.metadata.create_all(bind=create_engine(settings.DB_CONNECT_STRING['model_db']))



# print(DB_CONNECT_STRING['model_db'])
# Base = DB_Base()
# Base.metadata.drop_all(bind=DB_CONNECT_STRING['model_db'])
# Base.metadata.create_all(bind=DB_CONNECT_STRING['model_db'])

# md = MetaData(bind=engine)
# md.drop_all(bind=engine)
# md.create_all(bind=engine)


# class UserInfo(BaseTable):
#     #把表名赋给静态字段
#     __tablename__ = 'userinfo'
#     #序号nid，用户名username，密码password，邮箱email，创建时间ctime
#     #一行数据就是一个对象
#     nid = Column(Integer, primary_key=True, autoincrement=True)
#     username = Column(String(32))
#     password = Column(String(32))
#     email = Column(String(32))
#     ctime = Column(TIMESTAMP)
#
#     #建立组合索引，这里是方便在登陆采用不同的登陆方式也能更好的索引数据库
#     #用户名+密码   和   邮箱+密码   两种组合索引
#     __table_args__ = (
#         Index('ix_user_pwd', 'username', 'password'),
#         Index('ix_email_pwd', 'email', 'password'),
#     )
#
# class NewsType(BaseTable):
#
#     __tablename__ = 'newstype'
#     nid = Column(Integer, primary_key=True, autoincrement=True)
#     caption = Column(String(32))
#
# class News(BaseTable):
#
#     __tablename__ = 'news'
#
#     nid = Column(Integer, primary_key=True, autoincrement=True)
#     #建立外键---两个
#     user_info_id = Column(Integer, ForeignKey("userinfo.nid"))
#     news_type_id = Column(Integer, ForeignKey("newstype.nid"))
#     ctime = Column(TIMESTAMP)
#     title = Column(String(32))
#     url = Column(String(128))
#     content = Column(String(150))
#
# class Favor(BaseTable):
#     #点赞表
#     __tablename__ = 'favor'
#
#     nid = Column(Integer, primary_key=True, autoincrement=True)
#     #点赞者id
#     user_info_id = Column(Integer, ForeignKey("userinfo.nid"))
#     #信息id
#     news_id = Column(Integer, ForeignKey("news.nid"))
#     ctime = Column(TIMESTAMP)
#
#     #建立联合唯一索引
#     __table_args__ = (
#         UniqueConstraint('user_info_id', 'news_id', name='uix_uid_nid'),
#     )

