from model_data_api.handler.Base_Handler import BaseHandler
from model_data_api.views import *
from utils.tools import *
from utils import JsonUtil
import json

app = app()
@app.route('/api/datasetDetailRead')
class DatadetailreadHandler(BaseHandler):
    """读取文档"""
    def get(self, *args, **kwargs):
        # data_id = self.get_argument('data_id',default=None)
        try:

            file_path = self.get_argument('file_path',default=None)
            if file_path:
                try:
                    with open(get_path(common,'suite',file_path), 'r',encoding='utf8') as f:
                        result = json.loads(f.read())
                        f.close()

                    self.write(JsonUtil.build_json_data(code=JsonUtil.Constants.Code_Success,
                                                        message=JsonUtil.Constants.Msg_Success,
                                                        msg = "json 读取成功",
                                                        result=result
                                                        ))
                except:
                    self.write(JsonUtil.build_json_data(code=JsonUtil.Constants.Code_File_Error,
                                                        message=JsonUtil.Constants.Msg_File_Error

                                                        ))
            else:
                self.write(JsonUtil.build_json_data(code=JsonUtil.Constants.Code_Param_Error,
                                                    message=JsonUtil.Constants.Msg_Param_Error
                                                    ))
            self.flush()
            self.finish()
        except ValueError as e:
            self.write(JsonUtil.build_json(JsonUtil.Constants.Code_Param_Error, JsonUtil.Constants.Msg_Param_Error))
            self.flush()
        except IOError as e:
            self.write(JsonUtil.build_json(JsonUtil.Constants.Code_File_Error, JsonUtil.Constants.Msg_File_Error))
            self.flush()
        except Exception as e:
            # == 报异常，查询失败
            self.write(JsonUtil.build_json(JsonUtil.Constants.Code_Error, JsonUtil.Constants.Msg_Error))
            self.flush()