# -*- coding:utf-8 -*-


from model_data_api.handler.Base_Handler import BaseHandler
from model_data_api.views import *

from model_data_api.model.userTestData_model import UserTestDataManager
from model_data_api.handler.logic import *

app = app()
@app.route('/api/usertest')
class UserTestDataHandler(BaseHandler):

    def initialize(self):
        self.session = UserTestDataManager()

    def get(self):
        try:
            model_name = self.get_argument('model_name',default=None)
            data_set = self.get_argument('data_set_datail_id')
            result = get_userTest_logic(self.session,model_name,data_set)
            self.write(JsonUtil.build_json_data(code=result['code'],
                                                message=result['message'],
                                                result = result['result']
                                                ))
            self.flush()
            self.finish()
        except ValueError as e:
            self.write(JsonUtil.build_json(JsonUtil.Constants.Code_Param_Error, JsonUtil.Constants.Msg_Param_Error))
            self.flush()
        except IOError as e:
            self.write(JsonUtil.build_json(JsonUtil.Constants.Code_File_Error, JsonUtil.Constants.Msg_File_Error))
            self.flush()
        except Exception as e:
            # == 报异常，查询失败
            self.write(JsonUtil.build_json(JsonUtil.Constants.Code_Error, JsonUtil.Constants.Msg_Error))
            self.flush()
    def post(self):
        try:
            file_path = self.get_argument('file_path',default=None)
            result = add_userTest_logic(self.session,file_path,common)
            self.write(JsonUtil.build_json_data(code=result['codes'],
                                                message=result['message'],

                                                ))
            self.flush()
            self.finish()
        except ValueError as e:
            self.write(JsonUtil.build_json(JsonUtil.Constants.Code_Param_Error, JsonUtil.Constants.Msg_Param_Error))
            self.flush()
        except IOError as e:
            self.write(JsonUtil.build_json(JsonUtil.Constants.Code_File_Error, JsonUtil.Constants.Msg_File_Error))
            self.flush()
        except Exception as e:
            # == 报异常，查询失败
            self.write(JsonUtil.build_json(JsonUtil.Constants.Code_Error, JsonUtil.Constants.Msg_Error))
            self.flush()



