# -*- coding:utf-8 -*-
from utils import JsonUtil
from model_data_api.handler.Base_Handler import BaseHandler
from model_data_api.model.modelsData_model import ModelsDataManager
from model_data_api.model.featureData_model import FeatureDataManager
from model_data_api.model.dataSet_model import DataSetManager
from model_data_api.model.dataSetDetail_model import DataSetDetailManager
from model_data_api.model.userTestData_model import UserTestDataManager
from model_data_api.views import *
from model_data_api.handler.logic import *


import requests
app = app()
@app.route('/api/automatic')
class AutomaticHandler(BaseHandler):
    """一键数据生成"""
    def post(self):
        self.model_name = self.get_argument('model_name',default=None)
        self.user_count = self.get_argument('user_count',default=None)
        if self.model_name and self.user_count:
            self.feature_name = None
            self.auto_feature = []
            self.auto_dataset = {"data_basic":{"model_name":self.model_name,"count":self.user_count},
                                 "data_detail":[]}
            try :
                url = 'http://rc-model-exec.quantgroups.com/manage/features'
                r = requests.post(url,data={'codes':self.model_name})
                if r.status_code == 200:
                    response = r.json()
                    self.feature_name = response['data'][self.model_name]['new']+response['data'][self.model_name]['old']
                    print('获取模型新旧数据：',self.feature_name)
                    result = self.get_auto()
                    self.write(JsonUtil.build_json_data(code=result['code'],
                                                        message=result['message'],
                                                        result = result['result'],
                                                        json_path = result['json_path']
                                                        ))
                    self.flush()
                    self.finish()
            except:
                self.write(JsonUtil.build_json_data(code=500,
                                                    message="特征列表获取失败",
                                                    result = [],
                                                    json_path = ''
                                                    ))
                self.flush()
                self.finish()
        else:
            self.write(JsonUtil.build_json_data(code=JsonUtil.Constants.Code_Param_Error,
                                                message=JsonUtil.Constants.Msg_Param_Error
                                                ))
            self.flush()
            self.finish()

    def get_auto(self):
        modelsData = ModelsDataManager()
        featureData = FeatureDataManager()
        dataSet = DataSetManager()
        dataSetDetail = DataSetDetailManager()
        userTestData = UserTestDataManager()

        result_model = add_models_logic(modelsData,self.model_name,'自动生成','自动')
        print("模型创建结果:",result_model)
        for f in self.feature_name:
            self.auto_feature.append({'feature_name':f,'feature_content':'自动生成','assert_name':'模型测试'})

        result_feature = add_features_logic(featureData,self.auto_feature)
        print('添加特征结果：',result_feature)


        for f in self.auto_feature:
            self.auto_dataset['data_detail'].append(f)
        result_dataset = set_modelsAndfeature_logic(dataSet,self.auto_dataset)
        print("模型和特征挂钩结果：",result_dataset)
        result_datasetdetail = create_dataSet_logic(dataSetDetail,self.model_name,common)
        print("创建测试数据目录备份测试数据文件：",result_datasetdetail)
        result_add_userTest = None
        if result_datasetdetail['code'] == 200:
            result_add_userTest = add_userTest_logic(userTestData,result_datasetdetail['result']['detail_path'],common,isTrue=common.get('ISTRUE'))

        result_userTest = None
        if result_add_userTest['code'] == 200:
            result_userTest = get_userTest_logic(userTestData,self.model_name,result_add_userTest['set_datail_id'])
        result_userTest['json_path'] = result_datasetdetail['result']['detail_path']
        return result_userTest

