from model_data_api.model.base_model import BaseManager
from model_data_api.model.tab_model import TabAssertData

class AssertDataManager(BaseManager):
    def find_all(self):
        return self.get_json(self.session.query(TabAssertData).all())

    def find_single(self, name):
        return self.get_json(self.session.query(TabAssertData).filter_by(assert_name = name))

    def find_condition(self, **kwargs):
        return self.session.query(TabAssertData).filter(**kwargs)

    # def create_obj(self,assert_name,assert_content,assert_value,assert_type):
    #     p = TabAssertData(assert_name=assert_name,assert_content=assert_content,assert_value=assert_value,assert_type=assert_type)
    #     self.session.add(p)
    #     self.session.commit()

    def create_obj(self,basic_data,raw_data):
        p = []
        for data in raw_data:
            p.append(
                    TabAssertData(assert_name = basic_data['assert_name'],
                                  assert_content =basic_data['assert_content'],
                                  assert_type =data['assert_type'],
                                  assert_value =data['assert_value'],
                                  assert_gdp =data['assert_gdp'],
                                  data_type = data['data_type'],
                                  data_round = data['data_round']
                                   ))
        self.session.add_all(p)
        self.session.commit()