# -*- coding:utf-8 -*-

# from model_data_api.models import DataSet
from model_data_api.model.dataSet_model import DataSetManager
from model_data_api.handler.Base_Handler import BaseHandler
from model_data_api.views import *

from model_data_api.handler.logic import *
import pymysql
app = app()
import json

@app.route('/api/dataset')
class DataSetHandler(BaseHandler):
    def initialize(self):
        self.session = DataSetManager()
        pass
    def on_finish(self):
        self.session.close()

    def delete(self):
        items = self.get_arguments('item[]')
        self.write(str(items))

    def post(self,*args,**kwargs):
        # data = self.request.body_arguments
        try:
            data = []
            if self.request.body:
                data = json.loads(self.request.body)
            print(data)
            result = set_modelsAndfeature_logic(self.session,data)

            self.write(JsonUtil.build_json_data(code=result['code'],
                                           message=result['message'],
                                           result = result['result']
                                           ))
            self.flush()
            self.finish()

        except ValueError as e:
            self.write(JsonUtil.build_json_data(code=JsonUtil.Constants.Code_Param_Error,message= JsonUtil.Constants.Msg_Param_Error,data=data))
            self.flush()

        except Exception as e:
        # == 报异常，查询失败

            self.write(JsonUtil.build_json_data(code=JsonUtil.Constants.Code_Error,message= e.args,data=data))
            self.flush()

