# -*- coding:utf-8 -*-
from utils import JsonUtil
from model_data_api.handler.Base_Handler import BaseHandler
from model_data_api.model.modelsData_model import ModelsDataManager
from model_data_api.model.featureData_model import FeatureDataManager
from model_data_api.model.dataSet_model import DataSetManager
from model_data_api.model.dataSetDetail_model import DataSetDetailManager
from model_data_api.model.userTestData_model import UserTestDataManager
from model_data_api.views import *
from model_data_api.handler.logic import *


import requests
app = app()
@app.route('/api/automatic')
class AutomaticHandler(BaseHandler):
    """一键数据生成"""
    def post(self):
        self.model_name = self.get_argument('model_name',default=None)
        self.user_count = self.get_argument('user_count',default=None)
        if self.model_name and self.user_count:
            self.feature_name = None
            self.auto_feature = []
            self.auto_dataset = {"data_basic":{"model_name":self.model_name,"count":self.user_count},
                                 "data_detail":[]}

            url = 'http://172.21.10.25:9012/manage/features'
            r = requests.post(url,data={'codes':self.model_name})
            if r.status_code == 200:
                response = r.json()
                self.feature_name = response['data'][self.model_name]['new']+response['data'][self.model_name]['old']

            result = self.get_auto()
            self.write(JsonUtil.build_json_data(code=result['code'],
                                                message=result['message'],
                                                result = result['result'],
                                                json_path = result['json_path']
                                                ))
            self.flush()
            self.finish()
        else:
            self.write(JsonUtil.build_json_data(code=JsonUtil.Constants.Code_Param_Error,
                                                message=JsonUtil.Constants.Msg_Param_Error
                                                ))
            self.flush()
            self.finish()

    def get_auto(self):
        modelsData = ModelsDataManager()
        featureData = FeatureDataManager()
        dataSet = DataSetManager()
        dataSetDetail = DataSetDetailManager()
        userTestData = UserTestDataManager()

        result_model = add_models_logic(modelsData,self.model_name,'自动生成','自动')

        for f in self.feature_name:
            self.auto_feature.append({'feature_name':f,'feature_content':'自动生成','assert_name':'模型测试'})

        result_feature = add_features_logic(featureData,self.auto_feature)

        for f in self.auto_feature:
            self.auto_dataset['data_detail'].append(f)
        result_dataset = set_modelsAndfeature_logic(dataSet,self.auto_dataset)

        result_datasetdetail = create_dataSet_logic(dataSetDetail,self.model_name,common)
        result_add_userTest = None
        if result_datasetdetail['code'] == 200:
            result_add_userTest = add_userTest_logic(userTestData,result_datasetdetail['result']['detail_path'],common)

        result_userTest = None
        if result_add_userTest['code'] == 200:
            result_userTest = get_userTest_logic(userTestData,self.model_name,result_add_userTest['set_datail_id'])
        result_userTest['json_path'] = result_datasetdetail['result']['detail_path']
        return result_userTest

