#!/usr/bin/env python
# -*- coding:utf-8 -*-
import logging
from tornado.httpserver import HTTPServer
from tornado.ioloop import IOLoop
import tornado.options
import tornado.web
from model_data_api import views
from model_data_test.settings import PORT,DEBUG

class LogFormatter(tornado.log.LogFormatter):
    def __init__(self):
        super(LogFormatter, self).__init__(
                fmt='%(color)s[%(asctime)s %(filename)s:%(funcName)s:%(lineno)d %(levelname)s]%(end_color)s %(message)s',
                datefmt='%Y-%m-%d %H:%M:%S'
        )

if __name__ == "__main__":


    if DEBUG:
        app = views.app()
        server = HTTPServer(app)
        [i.setFormatter(LogFormatter()) for i in logging.getLogger().handlers]

        # #== 本地调试
        app.listen(PORT)
        IOLoop.instance().start()
    else:
        app = views.app()
        http_server = tornado.httpserver.HTTPServer(app)
        [i.setFormatter(LogFormatter()) for i in logging.getLogger().handlers]
        http_server.bind(PORT)
        http_server.start(num_processes=0)
        tornado.ioloop.IOLoop.instance().start()


    # app = views.app()
    # http_server = tornado.httpserver.HTTPServer(app)
    # http_server.bind(PORT)
    # http_server.start()
    # tornado.ioloop.IOLoop.instance().start()

