# -*- coding:utf-8 -*-


from model_data_api.handler.Base_Handler import BaseHandler
from model_data_api.views import *
from utils import JsonUtil
from model_data_api.model.userTestData_model import UserTestDataManager
import requests
import pandas as pd
import json
import hashlib

app = app()
@app.route('/api/model/exec')
class ModelsExecHandler(BaseHandler):

    def initialize(self):
        self.session = UserTestDataManager()
    def post(self):
        try :
            batch_uuid = self.get_argument('batch_uuid',default=None)
            if batch_uuid:
                result = self.session.find_single(batch_uuid)
                if result:
                    data_detail = result['data_detail']
                    if isinstance(data_detail,str):
                        data_detail = eval(data_detail)
                    _result = data_detail
                    _result['data']['subInfo'] = {}
                    _result['data']['subInfo'] ={'batchUuid':result['batch_uuid']}

                    self.write(JsonUtil.build_json_with_data(code=JsonUtil.Constants.Code_Success,
                                                             msg= JsonUtil.Constants.Msg_Success,
                                                             message="",
                                                            data = _result['data']
                                                        ))
                else:
                    self.write(JsonUtil.build_json_with_data(code=JsonUtil.Constants.Code_Fail,
                                                             msg= JsonUtil.Constants.Msg_Fail,
                                                             message="无此用户"
                                                             ))
            else:
                self.write(JsonUtil.build_json_data(code=JsonUtil.Constants.Code_Param_Error,
                                                    msg=JsonUtil.Constants.Msg_Param_Error
                                                    ))
            self.flush()
            self.finish()
        except ValueError as e:
            self.write(JsonUtil.build_json_with_data(code=JsonUtil.Constants.Code_Param_Error, msg=JsonUtil.Constants.Msg_Param_Error,message="出错了!!",batchUuid = batch_uuid))
            self.flush()

        except Exception as e:
            # == 报异常，查询失败
            self.write(JsonUtil.build_json_with_data(code=JsonUtil.Constants.Code_Error,msg=JsonUtil.Constants.Msg_Error,message="出错了",batchUuid = batch_uuid))
            self.flush()

def get_change(x):
    _dict = {
        "code": 200,
        "data": {"features": None}
    }
    _list = {}
    for key ,value in zip(x.keys(),x.values):
        _list = dict(_list, **{key:{'state':200,'value':value}})
    _dict['data']['features'] = _list
    return _dict
