# 项目配置信息模块
import os
from datetime import datetime
from tornado.options import options, define
from datetime import datetime

BASE_DIR = os.path.dirname(os.path.dirname(os.path.abspath(__file__)))
define("debug", default=True, help="enable debug mode",type=bool)
define("mode", default="debug", help="run mode")
define("port",default=23020,type=int)
define("ambient",default='dev')
# options.log_file_prefix = os.path.join(BASE_DIR, 'logs/model_data_api_%s.log'%(str(datetime.now()).split(' ')[0]))
options.parse_command_line()

DEBUG = options.debug
PORT = options.port
AMBIENT = options.ambient

if AMBIENT == 'dev' or AMBIENT =='test':
    options.log_file_prefix = os.path.join(BASE_DIR, 'logs/%s.log'%(str(datetime.now()).split(' ')[0]))
else:
    # '/home/quant_group/logs/model_data_api/model_data_api_%s.log'%(str(datetime.now()).split(' ')[0])
    options.log_file_prefix = os.path.join(BASE_DIR,'/home/quant_group/logs/model_data_api/%s.log'%(str(datetime.now()).split(' ')[0]))
options.parse_command_line()


INSTALLED_APPS = [
    'model_data_api'
]

DB_CONNECT_STRING = None
# if DEBUG:
if AMBIENT == 'dev' or AMBIENT =='test':
    DB_CONNECT_STRING = { # 支持多个数据库
        'model_db':'mysql+pymysql://qa:qatest@172.17.5.13:30267/model_data_test?charset=utf8',
        #'model_db':'mysql+pymysql://root:root@127.0.0.1:3306/model_data_test?charset=utf8',
    }
elif AMBIENT == 'online':
    DB_CONNECT_STRING = { # 支持多个数据库
        'model_db':'mysql+pymysql://qa:qatest@172.17.5.13:30267/model_data_test?charset=utf8',
    }

STATICFILES_DIRS = (
    os.path.join(BASE_DIR, 'static'),  # 静态文件额外目录
)

common = dict(
        static_path = os.path.join(BASE_DIR, "static"),
        template_path= os.path.join(BASE_DIR, "templates"),
        static_url_prefix=os.path.join(BASE_DIR, "/static/"),
        autoreload = True,
        DEBUG = DEBUG,
        suite = os.path.join(BASE_DIR,"")
)
