import tornado.web

class RouterConfig(tornado.web.Application):
    """ 重置Tornado自带的路有对象 """

    def route(self, url):
        """
       :param url: URL地址
       :return: 注册路由关系对应表的装饰器
       """

        def register(handler):
            """
           :param handler: URL对应的Handler
           :return: Handler
           """
            self.add_handlers(".*$", [(url, handler)]) # URL和Handler对应关系添加到路由表中
            return handler

        return register