import tornado.web
from model_data_test.settings import common

class RouterConfig(tornado.web.Application):
    """ 重置Tornado自带的路有对象 """
    def __init__(self):
        tornado.web.Application.__init__(self,**common)

    def route(self, url):
        """
       :param url: URL地址
       :return: 注册路由关系对应表的装饰器
       """
        def register(handler):
            """
           :param handler: URL对应的Handler
           :return: Handler
           """
            self.add_handlers(".*$", [(url, handler)]) # URL和Handler对应关系添加到路由表中

            return handler
        return register

__app__ = RouterConfig()

def app():
    return __app__


